/******************************************************************************/
#include "stdafx.h"
/******************************************************************************

   Skeleton points are special points attached to skeletons

   They can be used to render items in correct places

   Skeleton points can be accessed after animating skeleton, through CSkeleton::Point method,
   which returns reference to OrientP structure which is an orientation and position

   OrientP can be converted to Matrix through OrientP::matrix

/******************************************************************************/
CSkeleton cskel;
/******************************************************************************/
void InitPre()
{
   App.name="Skeleton Points";
   App.flag=APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=2;
   Cam.yaw =PI;

   cskel.create("../data/obj/chr/skeleton/0.skel",1.7);
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ROT|CAMH_ZOOM);

   // set animations
   cskel.clear().animate("../data/anim/walk.anim",Tm.time()).updateMatrix(MatrixIdentity).updateVelocities();

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
   LightDir(1,Vec(0,0,-1)).set();

   // draw mesh
   Meshs("../data/obj/chr/skeleton/0.mesh")->draw(cskel);

   // draw skeleton point
   MatrixSet();
   cskel.getPoint("HandR").draw(RED);
   cskel.getPoint("HandL").draw(RED);
   cskel.getPoint("Head" ).draw(RED);

   // draw item in right hand
   {
      OrientP &hand_r=cskel.getPoint("HandR");
      Matrix   m;
      m.setPosDir(hand_r.pos,hand_r.perp,hand_r.dir)               // set position and directions according to skeleton point
       .scaleOrn(0.7);                                             // scale down the matrix orientation a little, making the item smaller
      Meshs("../data/obj/item/weapon/blunt/club/0.mesh")->draw(m); // render item with matrix
   }
}
/******************************************************************************/
